<?php

$projectsMangmentOBJ = new ProjectsMangment();

class ProjectsMangment
{

	var $mDb;
	var $mConfig;
	var $mlang;

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
	}


	function convert_object_to_array($data)
	{
        
		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}
function getAllProjects($aStart, $aLimit, $sort, $type, $searchTitle,$developer_id,$city_id) {
    // echo $developer_id ;
    //  echo $city_id;
    
    $lang_code = LANGUAGE;
    
        $sql = "SELECT DISTINCT  p.id ,p.status,p.image,pl.name AS project_name ,p.date_added ,d.name AS developer_name,u.full_name,cl.name AS city_name , dl.name
        FROM projects_management p 
        LEFT JOIN projects_management_langs pl ON p.id = pl.project_id AND pl.lang_code = :lang_code 
        LEFT JOIN cities_management_langs cl ON p.city_id = cl.city_id AND cl.lang_code = :lang_code
        LEFT JOIN developers_management_langs d ON p.company_id = d.company_id  AND d.lang_code = :lang_code
        LEFT JOIN users u ON p.added_by = u.id 
        LEFT JOIN developers_management_langs dl ON p.company_id = dl.company_id AND dl.lang_code = :lang_code 
        WHERE p.is_deleted ='0' ";
     

    if ($searchTitle) {
    $searchTitle = '%' . $searchTitle . '%'; // إضافة النسبة المئوية إلى العنوان
        $sql .= " AND pl.name 
        
        LIKE :searchTitle";
    }
    if ($developer_id) {
        $sql .= " AND p.company_id = :company_id ";
    }
    if ($city_id){
        $sql .= "AND p.city_id = :city_id ";
    }
    $sql .= " ORDER BY {$sort} {$type}";

    if ($aLimit) {
        $sql .= " LIMIT :aStart, :aLimit";
        }
    // print_r($sql);die();
    try {

        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
        if ($searchTitle) {
            $stmt->bindParam(':searchTitle', $searchTitle, PDO::PARAM_STR);
        }

        if ($aLimit) {
            $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
            $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
        }
         if ($developer_id) {
            $stmt->bindParam(":company_id",$developer_id);
           }
        if ($city_id){
             $stmt->bindParam(":city_id",$city_id);
        }
        $stmt->execute();
   
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
      
        return $results;

    } catch (PDOException $e) {
        error_log("PDOException in getAllPages: " . $e->getMessage());
        return array();
    }
}


function getAllProjectCount($searchTitle,$developer_id,$city_id) {
    
    
    $lang_code = LANGUAGE;
    $sql = "SELECT COUNT(p.id)
            FROM projects_management p 
             LEFT JOIN projects_management_langs pl ON p.id = pl.project_id AND pl.lang_code = :lang_code 
            
            WHERE p.is_deleted = '0'";
            
    if ($searchTitle) {
    $searchTitle = '%' . $searchTitle . '%'; // إضافة النسبة المئوية إلى العنوان
        $sql .= " AND pl.name 
        
        LIKE :searchTitle";
    }
            
            
      if ($developer_id) {
        $sql .= " AND p.company_id = :company_id ";
    }
    if ($city_id){
        $sql .= " AND p.city_id = :city_id ";
    }
    
    
    try {
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':lang_code',$lang_code);
         if ($developer_id) {
            $stmt->bindParam(":company_id",$developer_id);
           }
        if ($city_id){
             $stmt->bindParam(":city_id",$city_id);
        }    
         if ($searchTitle) {
            $stmt->bindParam(':searchTitle', $searchTitle, PDO::PARAM_STR);
        }
        $stmt->execute(); // تصحيح اسم الدالة
        $data = $stmt->fetch(PDO::FETCH_COLUMN); // استخدام FETCH_ASSOC لسهولة الوصول
        
        return $data; // إرجاع العدد
    } catch (PDOException $e) {
        // تسجيل الخطأ في حال حدوث استثناء
        error_log("Error in getAllProjectCount: " . $e->getMessage());
        return 0; // إرجاع 0 عند حدوث خطأ
    }
}






function addEditProject($request) {


    unset($request['action']);
    $dataLangObj = json_decode($request['langs']);
    $newDataLangObj = $this->convert_object_to_array($dataLangObj);
    $units = $this->convert_object_to_array(json_decode($request['units'], true)); // لا حاجة لتمرير true في convert_object_to_array
    $images = json_decode($request['images']);

   
    $dateTime = date('Y-m-d H:i:s');
    // print_r($request);die();
    if (!$request['id']) {
        try{
            $sql = " INSERT INTO projects_management SET 
            city_id =:city_id,
            commision = :commision,
            deposit = :deposit,
            company_id = :company_id,
            status = :status,
            added_by = :added_by ,
            sales_phone =:sales_phone,
            sales_name  = :sales_name,
            installments_years=:installments_years,
            finishing = :finishing,
          
            sort = :sort , 
            date_added = :date_added
            ";
            if (isset($request['image']) &&!empty($request['image']))
                $sql.= ", image = :image ";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':city_id',$request['city_id']);
        $stmt->bindParam(':commision',$request['commision']);
        $stmt->bindParam(':deposit',$request['deposit']);
        $stmt->bindParam(':company_id',$request['company_id']);
        $stmt->bindParam(':status',$request['status']);
        $stmt->bindParam(':added_by',$request['user_id']);
        $stmt->bindParam(':sales_phone',$request['sales_phone']);
        $stmt->bindParam(':sales_name',$request['sales_name']);
        $stmt->bindParam(':installments_years',$request['installments_years']);
        $stmt->bindParam(':finishing',$request['finishing']);
        $stmt->bindParam(':status',$request['status']);
        $stmt->bindParam(':sort',$request['sort']);
        $stmt->bindParam(':date_added',$dateTime);
        // $stmt->bindParam(':type_id',$request['type_id']);
        if (isset($request['image']) &&!empty($request['image']))
        $stmt->bindParam(':image',$request['image']);
        $stmt->execute();
       
        // $data= $stmt->fetchAll(PDO::FETCH_ALL);
        $last_id = $this->mDb->connect()->lastInsertId();
        
        $units =$this->addProjetunits($units,$last_id);
        
        $langs = $this->addProjectLangs($newDataLangObj,$last_id); 
        $images = $this->addProjectImages($images,$last_id);
            


        return true;    
  
    }
        catch(PDOException $e){
            echo $e->getMessage();
        }  
    } else {
      
        $sql = "UPDATE projects_management SET ";
        $updateFields = [];
        $params = [];
        
        // Define a mapping of request fields to database columns
        $fieldsMap = [
            'city_id' => 'city_id',
            'commision' => 'commision',
            'deposit' => 'deposit',
            'company_id' => 'company_id',
            'status' => 'status',
            'sales_phone' => 'sales_phone',
            'sales_name' => 'sales_name',
            'installments_years' => 'installments_years',
            'finishing' => 'finishing',
            'sort' => 'sort',
            'type_id' => 'type_id'
        ];
        
        // Loop through the mapping and dynamically build the update fields and parameters
        foreach ($fieldsMap as $requestKey => $dbColumn) {
            if (!empty($request[$requestKey])) {
                $updateFields[] = "`$dbColumn` = :$requestKey";
                $params[":$requestKey"] = $request[$requestKey];
            }
        }
        
        // Ensure there are fields to update
        if (empty($updateFields)) {
            throw new Exception("No fields to update.");
        }
        
        $sql .= implode(", ", $updateFields);
        $sql .= " WHERE `id` = :id AND is_deleted = '0'";
        $params[':id'] = $request['id'];
        
        // Prepare and execute the statement
        $stmt = $this->mDb->connect()->prepare($sql);
        foreach ($params as $key => $value) {
            $stmt->bindValue($key, $value);
        }
        $updateCheck = $stmt->execute();
  
    if (isset($images)&&!empty($images)){
        $this->DeleteImagesForUpdate($request['id']);
        $this->addProjectImages($images,$request['id']);
    }
 
    if (isset($dataLangObj)&&!empty($dataLangObj)){      
        $this->DeleteLangsForUpdate($request['id']);
        $this->addProjectLangs($newDataLangObj,$request['id']);
    }

    if (isset($units)&&!empty($units)){
        $this->DeleteUnitsForUpdate($request['id']);
        $this->addProjetunits($units,$request['id']);
    }
   
        return true;
    }
    
    
}
function DeleteUnitsForUpdate($id){
     $sql = "DELETE FROM project_units WHERE project_id = :project_id";
    $stmt = $this->mDb->connect()->prepare($sql);
    $stmt->execute([':project_id'=>$id]);

}
function DeleteLangsForUpdate($id){
$sql = "DELETE FROM projects_management_langs WHERE project_id = :project_id";
$stmt = $this->mDb->connect()->prepare($sql);
$stmt->execute([':project_id' => $id]); 
}

function DeleteImagesForUpdate($id) {
    $sql = "DELETE FROM projects_management_images WHERE project_id = :project_id";
    $stmt = $this->mDb->connect()->prepare($sql);
    $stmt->execute([':project_id' => $id]); 
}


function addProjetunits($units,$last_id){

    $sql = "INSERT INTO project_units SET 
    project_id = :project_id 
    ,unit_id =:unit_id ,
    cost =:cost
    ,space = :space";
    $stmt =$this->mDb->connect()->prepare($sql);
    foreach($units As $unit){
    $stmt->bindParam(":project_id",$last_id); 
    $stmt->bindParam(':unit_id',$unit['id']);    
    $stmt->bindParam(':cost',$unit['cost']); 
    $stmt->bindParam(':space',$unit['space']);
    $stmt->execute();

}
if ($stmt->rowCount()>0)
        return true;
return false ;

}

public function addProjectLangs ($langs,$last_id){ 
   
    $sql = "INSERT INTO projects_management_langs SET 
    name = :name , 
    description = :description ,
    lang_code = :lang_code ,
    project_id = :project_id";
   
    $stmt = $this->mDb->connect()->prepare($sql);
    foreach($langs as $row ){
        $stmt->bindParam(':name',$row['name']);
        $stmt->bindParam(':description',$row['description']);
        $stmt->bindParam(':lang_code',$row['lang_code']);
        $stmt->bindParam(':project_id',$last_id);
        try{
        $stmt->execute();
         }
        catch(PDOException $e){
            echo $e->getMessage();
        } 
    
    }
    
    if ($stmt->rowCount()>0)
        return true;
    return false ;
}

function addProjectImages($images,$last_id){
    $sql ="INSERT INTO projects_management_images SET 
    file = :file ,
    project_id = :project_id  ";
    $stmt = $this->mDb->connect()->prepare($sql);
    foreach ($images As $row){
        $stmt->bindParam(':file',$row);
        $stmt->bindParam(':project_id',$last_id);
        $stmt->execute();

    }
    if ($stmt->rowCount()>0)
    return true;
return false ;
}


function getcitiesInfo (){
    
    $sql = "SELECT c.id,cl.name 
    FROM cities_management c 
    LEFT JOIN cities_management_langs cl ON c.id = cl.city_id  AND cl.lang_code = 'ar' 
    WHERE c.is_deleted = '0' ";
    $stmt = $this->mDb->connect()->prepare($sql);
   
    $stmt->execute();
  
   return $stmt->fetchAll(PDO::FETCH_ASSOC);
}


function getFinishingTypes (){
    $sql = "SELECT pmt.id,pmtl.name 
    FROM projects_management_types pmt 
    LEFT JOIN projects_management_type_langs pmtl ON pmt.id = pmtl.project_type_id  AND pmtl.lang_code = 'ar' 
     ";
    $stmt = $this->mDb->connect()->prepare($sql);
   
    $stmt->execute();
  
   return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function getProjectTypes(){
    
    $sql = "SELECT u.id,ul.name
     FROM unit_types u
     LEFT JOIN unit_types_langs ul ON u.id = ul.unit_type_id AND ul.lang_code = 'ar'
     WHERE u.parent = '0'";
    $stmt = $this->mDb->connect()->prepare($sql);
   
    $stmt->execute();
  
   return $stmt->fetchAll(PDO::FETCH_ASSOC);
}
function getunitTypes(){
    $lang_code = LANGUAGE;
    $sql = "SELECT u.id, ul.name
    FROM unit_types u
    LEFT JOIN unit_types_langs ul ON u.id = ul.unit_type_id AND ul.lang_code = :lang_code";
$stmt = $this->mDb->connect()->prepare($sql);
$stmt->bindParam(':lang_code',$lang_code);
// تنفيذ الاستعلام
$stmt->execute();

// جلب النتائج
return $stmt->fetchAll(PDO::FETCH_ASSOC);

//     $sql = "SELECT u.id,ul.name
//     FROM unit_types u
//     LEFT JOIN unit_types_langs ul ON u.id = ul.unit_type_id AND ul.lang_code = 'ar' ";
//   $stmt = $this->mDb->connect()->prepare($sql);
  
//   $stmt->execute([':id'=>$id]);
 
//   return $stmt->fetchAll(PDO::FETCH_ASSOC);
}


function getOneProject($id) {
    $lang_code = LANGUAGE;
    $sql = "SELECT 
                p.id,
                p.city_id,
                p.company_id,
                p.commision, 
                p.deposit, 
                p.image ,
                p.status, 
                p.sales_phone, 
                p.sales_name, 
                p.sales_whatsapp, 
                p.installments_years, 
                p.sort, 
                p.finishing,
                p.date_added,
                pl.name AS project_name, 
                pl.description AS project_description,
                c.name AS company_name, 
                cl.name AS city_name, 
                im.file AS image_file, 
                pu.cost, 
                pu.space,
                tl1.unit_type_id AS unit_id,
                tl1.name AS units_type,
                pl.lang_code AS project_lang
            FROM projects_management p
            LEFT JOIN projects_management_langs pl ON p.id = pl.project_id 
            LEFT JOIN developers_management_langs c ON p.company_id = c.company_id AND c.lang_code = :lang_code
            LEFT JOIN cities_management_langs cl ON p.city_id = cl.city_id AND cl.lang_code = :lang_code
            LEFT JOIN projects_management_images im ON im.project_id = p.id 
            LEFT JOIN project_units pu ON p.id = pu.project_id
            LEFT JOIN unit_types_langs tl1 ON pu.unit_id = tl1.unit_type_id AND tl1.lang_code = :lang_code
            WHERE p.is_deleted = '0' AND p.id = :id";

    $stmt = $this->mDb->connect()->prepare($sql);
    $stmt->execute([':id' => $id, ':lang_code' => $lang_code]);
    
    $project_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if (!empty($project_data)) {
        // Basic Project Information
        $result = [
            'id' => $project_data[0]['id'],
            'city_id'=>$project_data[0]['city_id'],
            'company_id'=>$project_data[0]['company_id'],
            'type_id'=>$project_data[0]['type_id'],
            'finishing'=>$project_data[0]['finishing'],
            'image'=>$project_data[0]['image'],
            'commision' => $project_data[0]['commision'],
            'deposit' => $project_data[0]['deposit'],
            'status' => $project_data[0]['status'],
            'sales' => [
                'phone' => $project_data[0]['sales_phone'],
                'name' => $project_data[0]['sales_name'],
                'whatsapp' => $project_data[0]['sales_whatsapp']
            ],
            'installments_years' => $project_data[0]['installments_years'],
            'sort' => $project_data[0]['sort'],
            'date_added' => $project_data[0]['date_added'],
            'company' => $project_data[0]['company_name'],
            'city' => $project_data[0]['city_name'],
            'type' => $project_data[0]['project_type'],
            'languages' => [],
            'units' => [],
            'images' => []
        ];

        // Collect Unique Languages, Units, and Images
        foreach ($project_data as $row) {
            // Languages
            if (!empty($row['project_lang']) && !in_array($row['project_lang'], array_column($result['languages'], 'lang_code'))) {
                $result['languages'][] = [
                    'lang_code' => $row['project_lang'],
                    'name' => $row['project_name'],
                    'description' => $row['project_description']
                ];
            }

            // Units
            if (!empty($row['unit_id']) && !in_array($row['unit_id'], array_column($result['units'], 'id'))) {
                $result['units'][] = [
                    'id' => $row['unit_id'],
                    'cost' => $row['cost'],
                    'space' => $row['space'],
                    'type' => $row['units_type']
                ];
            }

            // Images
            if (!empty($row['image_file']) && !in_array($row['image_file'], $result['images'])) {
                $result['images'][] = $row['image_file'];
            }
        }

        return $result;
    }

    return null; // If no data found
}

function deleteProject($ids)
{
    // Decode and validate input
    // $ids = json_decode($ids, true);
    if (!is_array($ids) || empty($ids)) {
        return "Invalid input: IDs must be a non-empty JSON array.";
    }

    // Ensure all IDs are integers
    $ids = array_filter($ids, fn($id) => is_numeric($id));
    if (empty($ids)) {
        return "Invalid input: All IDs must be numeric.";
    }

    // Prepare placeholders for the query
    $placeholders = implode(',', array_fill(0, count($ids), '?'));

    // SQL Query
    $sql = "UPDATE `projects_management` 
            SET `is_deleted` = '1' 
            WHERE `id` IN ($placeholders)";

    try {
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->execute($ids);

        // Check rows affected
        $rowCount = $stmt->rowCount();
        if ($rowCount > 0) {
            return "Projects deleted successfully. Total: $rowCount.";
        } else {
            return "No projects were deleted. Please check the IDs.";
        }
    } catch (PDOException $e) {
        // Log the error (optional)
        error_log("Error deleting projects: " . $e->getMessage());

        return "An error occurred: " . $e->getMessage();
    }
}







} ?>