<?php

$closingDealsMangmentOBJ = new closingDealsMangment();

class closingDealsMangment
{

	var $mDb;
	var $mConfig;
	var $mlang;

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
	}


	function convert_object_to_array($data)
	{
        
		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}
    function getALLlosingDeals($aStart, $aLimit, $sort, $type, $searchTitle) {
        $lang_code = LANGUAGE;
        $db = $this->mDb->connect();
    
        // التحقق من القيم المدخلة للفرز والتصنيف
        $allowedSortColumns = ['id', 'status', 'name']; // أعمدة مسموح بالفرز بها
        $sort = in_array($sort, $allowedSortColumns) ? $sort : 'id'; // العمود الافتراضي
        $type = strtoupper($type) === 'DESC' ? 'DESC' : 'ASC'; // النوع الافتراضي
    
        // كتابة الاستعلام
        $sql = "SELECT SQL_CALC_FOUND_ROWS c.id, c.status,c.date_added, c.sales_name,c.project_name,c.company_name as developer_name,
                        u.full_name as added_by,u.phone as added_by_phone 
                FROM closing_deals_management c
                LEFT JOIN users u ON c.added_by = u.id 
                WHERE c.is_deleted = '0'";
    
        // إضافة ترتيب وتحديد النتائج
        $sql .= " ORDER BY $sort $type LIMIT :start, :limit";
  
        // تحضير وتنفيذ الاستعلام
        $stmt = $db->prepare($sql);
        // $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
        $stmt->bindParam(':start', $aStart, PDO::PARAM_INT);
        $stmt->bindParam(':limit', $aLimit, PDO::PARAM_INT);
        $stmt->execute();
    
        // الحصول على النتائج
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
        // الحصول على العدد الإجمالي
        $totalQuery = $db->query("SELECT FOUND_ROWS() as total");
        $total = $totalQuery->fetch(PDO::FETCH_ASSOC)['total'];
    
        // إرجاع البيانات
        return [
            'status' => 200,
            'data' => $data,
            'count' => $total,
            'success' => true
        ];
    }
    
    


function getOneClosingDeals($id) {
   $lang_code =LANGUAGE;

   $sql = "SELECT c.unit_id,c.company_name,c.project_name,c.unit_number,c.client_name,c.cost,c.image,c.status,c.date_added,u.full_name AS added_by,u.phone AS added_by_phone,c.client_phone,tl.name AS unit_type
   ,c.sales_name , c.sales_phone
   FROM closing_deals_management c 
   LEFT JOIN unit_types_langs tl ON c.unit_id = tl.unit_type_id AND tl.lang_code = :lang_code
   LEFT JOIN users u ON c.added_by = u.id 
   WHERE c.id = :id ";
    
   $stmt = $this->mDb->connect()->prepare($sql);
   $stmt->bindParam(':lang_code',$lang_code); 
   $stmt->bindParam(':id',$id);
   $stmt->execute();
   $data = $stmt->fetch(PDO::FETCH_ASSOC);
   
   return [
       'status' => 200,
       'data' => $data,
       'success' => true
   ];
}


} ?>