<?php

/* * *************************************************************************
 *
 *   PROJECT:  Aramedical system
 *   powerd by  IT PLUS
 *   Copyright 2013 IT Plus Inc
 *   http://it-plus.co/
 *
 * ************************************************************************* */
$settings = new Configuration();

class Configuration
{

    var $mDb;
    var $mMailer;
    var $prefix;
    var $mConfig;
    var $mDsp;
    var $config_file = "../includes/config.inc.php";

    function __construct()
    {

        global $Config;
        $this->mDb = new iplus();

        $this->mConfig = $Config;
    }

    /**
     * Saves configuration to a file
     *
     * @param array $aConfigs modified configuration array
     *
     * @return bool
     */
    function saveConfig($aConfigs)
    {
        $configs = $this->mergeConfig($aConfigs);
        // print_r($configs);die();

        /** now build string that will be written to config file * */
        $out_config = "<?php\n";

        foreach ($configs as $key => $value) {


            $out_config .= '$Config[\'' . $key . "'] = '" . addslashes($value) . "';\n";
        }
        $out_config .= "?>";
        // echo $out_config;die();
        /** write configuration to a file * */

        if (!file_exists($this->config_file)) {
            die('File does not exist');
        }

        $f = fopen($this->config_file, 'w');
        // echo $f;die();
        // echo get_magic_quotes_gpc; die();
        if (!$f) {
            return false;
        }
        $out_config = $out_config;

        fwrite($f, $out_config);
        fclose($f);

        return true;
    }

    /**
     * Compares current config and changed one
     *
     * @param arr $aConfigs modified configuration array
     *
     * @return arr
     */
    function mergeConfig($aConfigs)
    {
        global $Config;

        $merged = array_merge($Config, $aConfigs);

        foreach ($merged as $key => $value) {
            $config[$key] = stripslashes($value);
        }

        return $config;
    }

    function getAutoLoadSettings()
    {
        // echo $this->config_file;die();

        $sql = " SELECT name,value ";
        $sql .= " FROM `{$this->mPrefix}settings` ";
        $sql .= " WHERE `autoload`='1' ";
        // echo $sql;die();
        $res = $this->mDb->getAll($sql);
        foreach ($res as $k => $v) {
            $temp[$v['name']] = $v['value'];
        }
        return $temp;
    }

    function getGeneralSettingsRow($row)
    {
        $sql = "SELECT $row ";
        $sql .= "FROM `{$this->mPrefix}settings` ";
        $sql .= "WHERE `id`='1' ";

        return $this->mDb->getOne($sql);
    }

    function updateSettings($data)
    {
        // print_r($data);
        foreach ($data as $k => $v) {
            if ($k != 'edit') {
                $sql = "UPDATE `{$this->mPrefix}settings` SET ";
                $sql .= "`value`='{$v}' ";
                $sql .= "WHERE `name`='{$k}' ";

                $res = $this->mDb->query($sql);
            }
        }
        // unset($data['edit']);
        return $this->saveConfig($data);

    }
    function getSettingByName($name)
    {

        $sql = "SELECT `value` FROM `settings` WHERE `name` = '{$name}'";
        return $this->mDb->getOne($sql);
    }

}
?>