<?php

$sliderOBJ = new sliders();

class sliders
{

	var $mDb;
	var $mConfig;
	var $mlang;

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
	}


	function convert_object_to_array($data)
	{
        
		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}
function getallsliders($aStart, $aLimit, $sort, $type, $searchTitle) {
   
    $lang_code = LANGUAGE;
   
    $sql = "SELECT s.id, s.image,s.status,s.date_added, 
    u.full_name ,sl.name,sl.description  
    FROM sliders  s 
    LEFT JOIN slider_langs sl ON s.id = sl.slider_id AND sl.lang_code = :lang_code 
    LEFT JOIN users u  ON s.added_by = u.id " ;
   
    if ($searchTitle) {
        $sql .= "WHERE sl.name LIKE :searchTitle ";
    }
    $sql .= " ORDER BY {$sort} {$type}";

    if ($aLimit) {
        $sql .= " LIMIT :aStart, :aLimit";
    }
    
    try {

        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
        if ($searchTitle) {
            $stmt->bindParam(':searchTitle', $searchTitle, PDO::PARAM_STR);
        }

        if ($aLimit) {
            $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
            $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
        }
        $stmt->execute();
   
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

        return $results;    
        // return [
        //     'success'=>true,
        //     'data'=>$results,
        //     'status'=>200
        // ];

    } catch (PDOException $e) {
        error_log("PDOException in getAllPages: " . $e->getMessage());
        return array();
    }
}


function  getAllSliderCount() {
    // echo "HEo";die();
    $sql = "SELECT COUNT(p.id)
            FROM sliders p 
        ";
    try {
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->execute(); // تصحيح اسم الدالة
        $data = $stmt->fetch(PDO::FETCH_COLUMN); // استخدام FETCH_ASSOC لسهولة الوصول
        // retrun $data; // إرجاع العدد
        return $data; // إرجاع العدد
    } catch (PDOException $e) {
        // تسجيل الخطأ في حال حدوث استثناء
        error_log("Error in getAllProjectCount: " . $e->getMessage());
        return 0; // إرجاع 0 عند حدوث خطأ
    }
}






function addEditSliders($request) {

    unset($request['action']);
    $dataLangObj = json_decode($request['langs']);
    $newDataLangObj = $this->convert_object_to_array($dataLangObj);
  
    $dateTime = date('Y-m-d H:i:s');
   
    if (!$request['id']) {
        try{
            $sql = " INSERT INTO sliders SET 
            added_by= :added_by, 
            link = :link ,
            date_added =:date_added ";
            if (isset($request['image']) &&!empty($request['image']))
                $sql.= ", image = :image  ";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':added_by',$request['user_id']);
        $stmt->bindParam(':link',$request['link']);
        $stmt->bindParam(':date_added',$dateTime);
        if (isset($request['image']) &&!empty($request['image']))
        $stmt->bindParam(':image',$request['image']);
        $stmt->execute();
       
        // $data= $stmt->fetchAll(PDO::FETCH_ALL);
        $last_id = $this->mDb->connect()->lastInsertId();
        $this->addSliderLangs($newDataLangObj,$last_id);
        


        return [
            'success'=>true,
            'data' =>"Added Done ",
            'status'=>200
        ];    
  
    }
        catch(PDOException $e){
            echo $e->getMessage();
        }  
    }else {
        $sql = "UPDATE sliders SET ";
        $updateFields = [];
        $params = [];
    
        // التحقق من وجود الرابط
        if (isset($request['link']) && !empty($request['link'])) {
            $updateFields[] = "link = :link";
            $params[':link'] = $request['link'];
        }
    
        // التحقق من وجود الصورة
        if (isset($request['image']) && !empty($request['image'])) {
            $updateFields[] = "image = :image";
            $params[':image'] = $request['image'];
        }

        if (isset($request['status']) && !empty($request['status'])) {
            $updateFields[] = "status = :status";
            $params[':status'] = $request['status'];
        }

        if (isset($request['sort']) && !empty($request['sort'])) {
            $updateFields[] = "sort = :sort";
            $params[':sort'] = $request['sort'];
        }
    
        
        $sql .= implode(", ", $updateFields);
        $sql .= " WHERE id = :id"; // افتراض أن التحديث يتم بناءً على الحقل id
        $params[':id'] = $request['id']; // إضافة معرف التحديث
    
        // تحضير وتنفيذ الاستعلام
        $stmt = $this->mDb->connect()->prepare($sql);
        foreach ($params as $key => $value) {
            $stmt->bindValue($key, $value);
        }
    
        $updateCheck = $stmt->execute();
    
        // التحقق من وجود لغات مرتبطة بالتحديث
        if (isset($dataLangObj) && !empty($dataLangObj)) {
            $this->DeleteLangsForUpdate($request['id']); // حذف اللغات المرتبطة القديمة
            $this->addSliderLangs($newDataLangObj, $request['id']); // إضافة اللغات الجديدة
        }
    
        return [
            'success'=>true,
            'status'=>200,
            'data'=>'Updated  Successfully'
        ];
    }
    
    
}

function DeleteLangsForUpdate($id){
$sql = "DELETE FROM slider_langs WHERE slider_id = :slider_id";
$stmt = $this->mDb->connect()->prepare($sql);
$stmt->execute([':slider_id' => $id]); 
}

public function addSliderLangs ($langs,$last_id){ 
   
    $sql = "INSERT INTO slider_langs SET 
    name = :name , 
    description = :description ,
    lang_code = :lang_code ,
    slider_id = :slider_id";
   
    $stmt = $this->mDb->connect()->prepare($sql);
    foreach($langs as $row ){
        $stmt->bindParam(':name',$row['name']);
        $stmt->bindParam(':description',$row['description']);
        $stmt->bindParam(':lang_code',$row['lang_code']);
        $stmt->bindParam(':slider_id',$last_id);
        try{
        $stmt->execute();
         }
        catch(PDOException $e){
            echo $e->getMessage();
        } 
    
    }
    
    if ($stmt->rowCount()>0)
        return true;
    return false ;
}


function getOneSlider($id) {
      $sql = "SELECT s.id ,s.link, s.image,s.date_added,s.image,s.status,s.sort , sl.name ,sl.lang_code AS slider_lang, sl.description 
    FROM sliders s  
    LEFT JOIN slider_langs sl ON s.id = sl.slider_id 
    WHERE s.id = :id ";
    // print_r($sql);die();
    $stmt = $this->mDb->connect()->prepare($sql);
    $stmt->execute([':id' => $id]);
    
    $slider_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (!empty($slider_data)) {
        // Basic Project Information
        $result = [
            'id' => $slider_data[0]['id'],
            'img'=>$slider_data[0]['image'],
            'link' => $slider_data[0]['link'],
            'status' => $slider_data[0]['status'],
            'sort' => $slider_data[0]['sort'],
            'date_added' => $slider_data[0]['date_added'],
            'languages' => [],
        ];

        // Collect Unique Languages, Units, and Images
        foreach ($slider_data as $row) {
            // Languages
            if (!empty($row['slider_lang']) && !in_array($row['slider_lang'], array_column($result['languages'], 'lang_code'))) {
                $result['languages'][] = [
                    'lang_code' => $row['slider_lang'],
                    'name' => $row['name'],
                    'description' => $row['description']
                ];
            }

        }

        return [
            'data'=>$result,
            'success'=>true,
            'status'=>200];
    
    }

    return null; // If no data found
}

function deleteSliders($ids)
{
    if (!is_array($ids) || empty($ids)) {
        return [
            'success' => false,
            'message' => "Invalid input: IDs must be a non-empty array."
        ];
    }

    // Ensure all IDs are numeric
    $ids = array_filter($ids, fn($id) => is_numeric($id));
    if (empty($ids)) {
        return [
            'success' => false,
            'message' => "Invalid input: All IDs must be numeric."
        ];
    }

    // Prepare placeholders for the query
    $placeholders = implode(',', array_fill(0, count($ids), '?'));

    // SQL Queries
    $sql = "DELETE FROM `sliders` WHERE `id` IN ($placeholders)";
    $sqlLangs = "DELETE FROM `slider_langs` WHERE `slider_id` IN ($placeholders)";

    try {
        // Start a transaction
        $db = $this->mDb->connect();
        $db->beginTransaction();

        // Delete from sliders table
        $stmt = $db->prepare($sql);
        $stmt->execute($ids);
        $rowCount = $stmt->rowCount();

        // Delete from slider_langs table
        $stmtLangs = $db->prepare($sqlLangs);
        $stmtLangs->execute($ids);

        // Commit the transaction
        $db->commit();

        if ($rowCount > 0) {
            return [
                'success' => true,
                'message' => "Sliders deleted successfully. Total: $rowCount."
            ];
        } else {
            return [
                'success' => true,
                'message' => "No sliders were deleted. Please check the IDs."
            ];
        }
    } catch (PDOException $e) {
        // Rollback the transaction in case of an error
        $db->rollBack();

        // Log the error (optional)
        error_log("Error deleting sliders: " . $e->getMessage());

        return [
            'success' => false,
            'message' => "An error occurred: " . $e->getMessage()
        ];
    }
}


} ?>