<?php


$commonObj = new Common;
// echo"test";die();

class Common{
          var $mDb;
          var $mConfig;
      
          function __construct()
          {
              global $Config;
              $this->mDb = new iplus();
              $this->mConfig = $Config;
          }

          function getSettingByName($name)
    {
        $sql = " SELECT  value  FROM `settings` where name ='{$name}'  ";
        // echo $sql;die();
        $res = $this->mDb->getOne($sql);
    }
       public function upload_image($files, $folder_name)
{
    global $Config;

    $allow_ext = array("jpg", "gif", "png", "jpeg", "bmp", "webp");
    $maxsize = 1024 * 20; // Maximum size in KB

    $uploadFolder = $Config['uploads_path'] . $folder_name;

    $thumbsConfig = array(
        array(
            'name' => 'medium',
            'width' => '240',
            'height' => '250'
        ),
        array(
            'name' => 'small',
            'width' => '80',
            'height' => '80'
        ),
    );

    $upload = new Upload($allow_ext, $thumbsConfig, $maxsize, $uploadFolder, false);

    try {
        if (isset($files['img']) && !empty($files['img'])) {
            $img = $files['img'];

            $file['name'] = addslashes($img['name']);
            $file['type'] = $img['type'];
            $file['size'] = $img['size'] / 1024; // Convert to KB
            $file['tmp'] = $img['tmp_name'];
            $file['ext'] = $upload->GetExt($img["name"]);

            if ($file['name'] != '') {
                $upfile = $upload->Upload_File($file, $maxsize);

                if ($upfile) {
                    return [
                        'status' => 200,
                        'success' => true,
                        'data' => $upfile['newname']
                    ];
                } else {
                    return [
                        'status' => 400,
                        'success' => false,
                        'data' => $upload->showErrors()
                    ];
                }
            } else {
                return [
                    'status' => 400,
                    'success' => false,
                    'data' => 'No file selected'
                ];
            }
        } else {
            return [
                'status' => 400,
                'success' => false,
                'data' => 'Image file not provided'
            ];
        }
    } catch (Exception $e) {
        return [
            'status' => 500,
            'success' => false,
            'data' => 'An error occurred: ' . $e->getMessage()
        ];
    }
}

    
    public function fetchUsersAssociatedEvaluationWithStage_id($stage){

        $sql  = "SELECT u.full_name AS user_name, u.id AS user_id ";
        $sql .= ", sl.name AS stage_name ";
        $sql .= " FROM `users` u ";
        $sql .= " LEFT JOIN `user_stages` us ON u.id = us.user_id ";
        $sql .= " LEFT JOIN `stage_langs` sl ON sl.stage_id = us.stage_id AND sl.lang_code = :language";
        $sql .= " WHERE us.stage_id = :stage_id ";
        // echo  $sql;die();
        $stmt = $this->mDb->connect()->prepare($sql);
        // print_r($stmt);die();
        $language = LANGUAGE;
        $stmt->bindParam(':stage_id', $stage);
        $stmt->bindParam(':language', $language);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }


    public function getFieldsOwner(){
        $sql  = "SELECT u.full_name AS user_name, u.id AS user_id ";
        $sql .= " FROM `fields_owners` fo ";
        $sql .= " LEFT JOIN `users` u ON fo.user_id = u.id ";
        $sql .= " GROUP BY u.id ";
        // echo $sql;die();
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    function getAllSectors(){
        
        $sql = "SELECT s.id, sl.name FROM `sectors` s ";
        $sql .= " LEFT JOIN `sector_langs` sl ON s.id = sl.sector_id AND sl.lang_code = :lang_code ";
        $sql .= " WHERE s.is_deleted != '1' AND s.status = '1' ";
        
        $stmt = $this->mDb->connect()->prepare($sql);
        $lang_code = LANGUAGE;
        $stmt->bindParam(":lang_code", $lang_code);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
        
    }
public function getAllFields($user_id)
{
    $sql = "SELECT fo.id, fl.name 
            FROM `fields_owners` fo
            LEFT JOIN `field_langs` fl 
            ON fo.field_id = fl.field_id AND fl.lang_code = :lang_code
            WHERE fo.user_id = :user_id";

    $stmt = $this->mDb->connect()->prepare($sql);
    
    $lang_code = LANGUAGE; 
    $stmt->bindParam(":lang_code", $lang_code);
    $stmt->bindParam(":user_id", $user_id);
    
    $stmt->execute();
    
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

public function getAllIndicators($user_id)
{
    $sql = "SELECT i.id, il.name 
            FROM `indicators` i
            LEFT JOIN `fields_owners` fo ON i.field_id = fo.field_id
            LEFT JOIN `indicator_langs` il ON i.id = il.indicator_id AND il.lang_code = :lang_code
            WHERE fo.user_id = :user_id";
    
    $stmt = $this->mDb->connect()->prepare($sql);
     $lang_code = LANGUAGE; 
    $stmt->bindParam(":lang_code", $lang_code);
    $stmt->bindParam(":user_id", $user_id);
    
    $stmt->execute();
    
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

public function getAllStandards($user_id)
{
    $sql = "SELECT s.id, sl.name 
            FROM `standards` s
            LEFT JOIN `fields_owners` fo ON s.field_id = fo.field_id
            LEFT JOIN `standard_langs` sl ON s.id = sl.standard_id AND sl.lang_code = :lang_code
            WHERE fo.user_id = :user_id";
    
    $stmt = $this->mDb->connect()->prepare($sql);
     $lang_code = LANGUAGE; 
    $stmt->bindParam(":lang_code", $lang_code);
    $stmt->bindParam(":user_id", $user_id);
    
    $stmt->execute();
    
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}
    public function getUserType($user_id){
        try{
            $sql = "SELECT m.code FROM `memberships` m ";
            $sql .= " LEFT JOIN `users` u ON u.membership_id = m.id ";
            $sql .= " WHERE u.id = :user_id ";

            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(":user_id", $user_id);
            $stmt->execute();
            return $stmt->fetchColumn();
        }catch(Exception $e){
            echo $e->getLine() . " - " . $e->getMessage();
            die();
        }
    }


    public function getUserStages($user_id){

        try{
            $sql = "SELECT stage_id FROM `manager_stages` WHERE user_id = :user_id ";
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(":user_id", $user_id);
            $stmt->execute();
           
            return $stmt->fetchAll(PDO::FETCH_COLUMN);
        }catch(Exception $e){
            echo $e->getLine() . " - " . $e->getMessage();
            die();
        }
    }
    
   public function getStagesByUserId($user_id){

        try{
            $sql = "SELECT ms.stage_id, sl.name FROM `manager_stages` ms
            LEFT JOIN `stage_langs` sl ON ms.stage_id = sl.stage_id AND sl.lang_code = :lang_code
            WHERE ms.user_id = :user_id ";
            $stmt = $this->mDb->connect()->prepare($sql);
            $lang_code = LANGUAGE; 
            $stmt->bindParam(":lang_code", $lang_code);
            $stmt->bindParam(":user_id", $user_id);
            $stmt->execute();
           
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        }catch(Exception $e){
            echo $e->getLine() . " - " . $e->getMessage();
            die();
        }
    }
    public function mergeVisitDataToParams($arr, $id){
        $sql = "SELECT evaluation_id, stage_id, school_id, sector_id, visit_type FROM `visits` WHERE id = :id";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(":id", $id);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
    
        if($data){
          $arr['sector_id'] = $data['sector_id'];
          $arr['school_id'] = $data['school_id'];
          $arr['stage_id'] = $data['stage_id'];
          $arr['evaluation_id'] = $data['evaluation_id'];
          $arr['visit_type'] = $data['visit_type'];
    
    
          return $arr;
        } 
        return $arr;
    
      }
    // public function getAddetionVisitData($id, $arr){
    //     $sql = "SELECT evalutaion_id, sector_id, school_id, stage_id ";
    //     $sql .=" FROM `visits` ";
    //     $sql .= "WHERE id = :id ";
    // }
    
    
      public function getUserShools($user_id){
        try{
            $sql = "SELECT school_id  FROM `manager_stages` WHERE user_id = :user_id ";
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(":user_id", $user_id);
            $stmt->execute();
           
            return $stmt->fetchAll(PDO::FETCH_COLUMN);
        }catch(Exception $e){
            echo $e->getLine() . " - " . $e->getMessage();
            die();
        }
    }
  
    public function getUserData($sector_id, $user_code, $school_id='', $stage_id='')
{
    try {
        $sql  = "SELECT u.id, m.code ";
        $sql .= "FROM `users` u ";
        $sql .= "LEFT JOIN `memberships` m ON u.membership_id = m.id ";
        if ($user_code == 'school' || $user_code == 'stage' || $user_code == 'stage_officer') {
            $sql .= " LEFT JOIN `user_school` us ON u.id = us.user_id ";
        }
        if ($user_code == 'stage' || $user_code == 'stage_officer') {
            $sql .= " LEFT JOIN `manager_stages` ms ON u.id = ms.user_id ";
        }
        $sql .= "WHERE 1=1 ";  // This simplifies adding conditions dynamically
        $sql .= " AND m.code = :user_code ";
        
        // Apply condition if not 'chairman'
        if ($user_code != 'chairman') {
            $sql .= " AND u.sector = :sector_id ";
        }

        if ($user_code == 'school') {
            $sql .= " AND us.school_id = :school_id AND us.type = :user_code ";
        }


        if ($user_code == 'stage') {
            $sql .= " AND ms.stage_id = :stage_id AND ms.school_id = :school_id AND ms.type = 'stage' ";
        }
        if ($user_code == 'stage_officer') {
            $sql .= " AND ms.stage_id = :stage_id AND ms.school_id = :school_id AND ms.type = 'stage_officer' ";
        }
        // echo $sql;die();
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(":user_code", $user_code, PDO::PARAM_STR);
        if ($user_code == 'school' || $user_code == 'stage' || $user_code == 'stage_officer') {
            $stmt->bindParam(":user_code", $user_code, PDO::PARAM_STR);
            $stmt->bindParam(":school_id", $school_id, PDO::PARAM_STR);
        }


        if ($user_code == 'stage' || $user_code == 'stage_officer') {
            $stmt->bindParam(":stage_id", $stage_id, PDO::PARAM_STR);
        }

        // Bind sector_id if necessary
        if ($user_code != 'chairman') {
            $stmt->bindParam(":sector_id", $sector_id, PDO::PARAM_INT);
        }

        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        echo $e->getLine() . " - " . $e->getMessage();
        die();
    }
}

public function getUserSchools($user_id){
    
    try{
        $sql = "SELECT school_id FROM `user_school` WHERE user_id = :user_id ";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(":user_id", $user_id);
        $stmt->execute();
       
        return $stmt->fetchAll(PDO::FETCH_COLUMN);
    }catch(Exception $e){
        echo $e->getLine() . " - " . $e->getMessage();
        die();
    }
    
}

public function getAllMyEvaluation($temp){

    // print_r($temp);die();
    try{
      $arr1 = ['sector_quality_manager','complexes_quality_manager', 'school', 'satge', 'stage_officer'];
      $arr2 = ['complexes_quality_manager', 'school', 'satge', 'stage_officer'];
      $arr3 = ['satge', 'stage_officer', 'domain'];
      
      
      $sql = "SELECT e.id FROM `evaluations` e ";
      $sql .= " LEFT JOIN `evaluation_approvals` ea ON ea.evaluation_id = e.id ";
      $sql .= " WHERE ea.status = '1' AND ea.type = 'complexes_quality_manager' ";
    
      if(in_array($temp['user_type'],$arr1) || $temp['sector_id']){
        $sql .= " AND e.sector_id = :sector_id ";
      }

      if(in_array($temp['user_type'],$arr2) || $temp['schools']){
        $sql .= " AND e.school_id IN  " . $temp['schools'];
      }

      if(in_array($temp['user_type'],$arr3) || $temp['stages']){
        $sql .= " AND e.stage_id IN " . $temp['stages'];
      }

      $stmt = $this->mDb->connect()->prepare($sql);
      if(in_array($temp['user_type'],$arr1) || $temp['sector_id']){
          $stmt->bindParam(":sector_id", $temp['sector_id']);
        }
        //   echo $sql;die();
      
      $stmt->execute();
      return $stmt->fetchAll(PDO::FETCH_COLUMN);
    }catch(Exception $e){
      echo $e->getLine() . " - " . $e->getMessage();
      die();
    }
    
  }

  public function getUserSchoolsBySectorId($sector_id){

    $sql = "SELECT id FROM `schools` WHERE sector_id = '{$sector_id}'";
    $stmt = $this->mDb->connect()->prepare($sql);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_COLUMN);

  }

}
