<?php

$pagesObj = new pages();

class pages
{

	var $mDb;
	var $mConfig;
	var $mlang;

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
	}


	function convert_object_to_array($data)
	{

		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}
function getAllPages($aStart, $aLimit, $sort, $type, $searchTitle) {

    $lang_code = LANGUAGE;
    
    $sql = "SELECT p.id, p.status,p.img, p.date_added, pl.description, pl.title, pl.sub_title, u.full_name AS user_full_name 
            FROM pages p
            LEFT JOIN users u ON u.id = p.user_id
            LEFT JOIN pages_langs pl ON p.id = pl.page_id AND pl.lang_code= :lang_code
            WHERE p.id > 0 ";

    if ($searchTitle) {
        $sql .= " AND pl.title LIKE :searchTitle";
    }
    if ($sort == 'name')
    $sql .= " ORDER BY pl.title {$type}";
    else {
    $sql .= " ORDER BY p.{$sort} {$type}";
    }

    if ($aLimit) {
        $sql .= " LIMIT :aStart, :aLimit";
    }

    try {

        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
        if ($searchTitle) {
            $searchTitle = '%'. $searchTitle . '%';
            $stmt->bindParam(':searchTitle', $searchTitle, PDO::PARAM_STR);
        }

        if ($aLimit) {
            $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
            $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
        }
        $stmt->execute();
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $results;

    } catch (PDOException $e) {
        error_log("PDOException in getAllPages: " . $e->getMessage());
        return array();
    }
}


function getSearchPagesCount($searchTitle) {
    $lang_code = LANGUAGE;
    $sql = "SELECT COUNT(p.`id`) as result_count 
            FROM pages p
            LEFT JOIN pages_langs pl ON p.id = pl.page_id AND pl.lang_code = :lang_code
            WHERE p.`id` > 0 ";


    if (!empty($searchTitle)) {
        $sql .= " AND pl.title LIKE :searchTitle";
    }

    try {
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);


        if (!empty($searchTitle)) {
             $searchTitle = '%'. $searchTitle . '%';

            $stmt->bindParam(':searchTitle', $searchTitle, PDO::PARAM_STR);
        }
        $stmt->execute();

        return $stmt->fetchColumn();

    } catch (PDOException $e) {

        error_log("PDOException in getSearchPagesCount: " . $e->getMessage());
        return 0;
    }
}



function addEditPage($request) {
 

    unset($request['action']);
    $dataLangObj = json_decode($request['langs']);
    $newDataLangObj = $this->convert_object_to_array($dataLangObj);
    $dateTime = date('Y-m-d H:i:s');
    // print_r($request);die();
    if (!$request['id']) {
        // Insert operation
        $sql = "INSERT INTO `pages` SET `user_id` = :user_id, `date_added` = :dateTime";
        if ($request['status'] !== null) $sql .= ", `status` = :status";
        if ($request['file']) $sql .= ", `img` = :img";
        try {
            $this->mDb->beginTransaction();
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':user_id', $request['user_id']);
            $stmt->bindParam(':dateTime', $dateTime);
            if ($request['status'] !== null) $stmt->bindParam(':status', $request['status']);
            if ($request['file']) $stmt->bindParam(':img', $request['file']);
            $stmt->execute();

            $last_page_id = $this->mDb->getLastInsertId();
            foreach ($newDataLangObj as $key => $value) {
                $sqlForLang = "INSERT INTO `pages_langs` SET `page_id` = :page_id, `lang_code` = :lang_code, `title` = :title, `sub_title` = :sub_title, `description` = :description";

                $stmtForLang = $this->mDb->connect()->prepare($sqlForLang);
                $stmtForLang->bindParam(':page_id', $last_page_id);
                $stmtForLang->bindParam(':lang_code', $value['lang_code']);
                $stmtForLang->bindParam(':title', $value['title']);
                $stmtForLang->bindParam(':sub_title', $value['title']);
                $stmtForLang->bindParam(':description', $value['description']);
                $stmtForLang->execute();
            }

            $this->mDb->commit();
            
            return ["status" => 200, "message" => $request];
        } catch (PDOException $e) {
            $this->mDb->rollBack();
            echo $e->getMessage();die();
            if ($request['file']) {
                $eroredimg = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'pages/' . $request['file'];
                if (file_exists($eroredimg)) unlink($eroredimg);
            }
            return ["status" => 500, "message" => "An Error Occurred"]; 
        }
    } else {

        $sql = "UPDATE `pages` SET";
        try {
            $this->mDb->beginTransaction();

            if ($request['file']) {
                $sqlForImage = "SELECT `img` FROM `pages` WHERE `id` = :id";
                $stmtForImage = $this->mDb->connect()->prepare($sqlForImage);
                $stmtForImage->bindParam(':id', $request['id']);
                $stmtForImage->execute();
                $PageImage = $stmtForImage->fetch(PDO::FETCH_COLUMN);
            }

            $updateFields = [];
            if ($request['status'] !== null) $updateFields[] = "`status` = :status";
            if ($request['file']) $updateFields[] = "`img` = :img";

            if (count($updateFields) > 0) {
                $sql .= implode(", ", $updateFields) . " WHERE `id` = :id";
                $stmt = $this->mDb->connect()->prepare($sql);
                if ($request['file']) $stmt->bindParam(':img', $request['file']);
                if ($request['status'] !== null) $stmt->bindParam(':status', $request['status']);
                $stmt->bindParam(':id', $request['id']);
                $stmt->execute();
            }
            foreach ($newDataLangObj as $key => $value) {
                $sqlForGymLang = 'UPDATE `pages_langs` SET';
                $updateFieldsLang = [];
                if ($value['title']) $updateFieldsLang[] = "`title` = :title";
                if ($value['title']) $updateFieldsLang[] = "`sub_title` = :sub_title";
                if ($value['description']) $updateFieldsLang[] = "`description` = :description";

                if (count($updateFieldsLang) > 0) {
                    $sqlForGymLang .= implode(", ", $updateFieldsLang);
                    $sqlForGymLang .= " WHERE `page_id` = :pageId AND `lang_code` = :lang_code";

                    $stmtForLang = $this->mDb->connect()->prepare($sqlForGymLang);
                    if ($value['title']) $stmtForLang->bindParam(':title', $value['title']);
                    if ($value['title']) $stmtForLang->bindParam(':sub_title', $value['title']);
                    if ($value['description']) $stmtForLang->bindParam(':description', $value['description']);
                    $stmtForLang->bindParam(':pageId', $request['id']);
                    $stmtForLang->bindParam(':lang_code', $value['lang_code']);
                    $stmtForLang->execute();
                }
            }

            if ($request['file']) {
                $eroredimg = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'pages/' . $PageImage;
                if (file_exists($eroredimg)) unlink($eroredimg);
            }

            $this->mDb->commit();
            return ["status" => 200, "message" => "Updated"];
        } catch (PDOException $e) {
            if ($request['file']) {
                $eroredimg = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'pages/' . $request['file'];
                if (file_exists($eroredimg)) unlink($eroredimg);
            }
            return ["status" => 500, "message" => "An error occurred"];
        }
    }
}
function getOnePage($id) {
   $sql = "SELECT p.`id`, u.`full_name`, p.`user_id`, p.`status`, p.`date_added`, p.`img` 
        FROM `pages` p 
        LEFT JOIN `users` u ON u.`id` = p.`user_id` 
        WHERE p.`id` = :id";

    $stmt = $this->mDb->connect()->prepare($sql);

    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    if ($stmt->execute()) {
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$result) {
            throw new Exception("Page with ID $id not found.");
        }
    } else {
        throw new Exception("Error executing the main SQL statement: " . implode(", ", $stmt->errorInfo()));
    }

    $sqlLangs = "SELECT pl.`lang_code`, pl.`title`, pl.`sub_title`, pl.`description` FROM `pages_langs` pl WHERE pl.`page_id` = :id";
    $stmtLangs = $this->mDb->connect()->prepare($sqlLangs);

    $stmtLangs->bindParam(':id', $id, PDO::PARAM_INT);
    if ($stmtLangs->execute()) {
        $result['langs'] = $stmtLangs->fetchAll(PDO::FETCH_ASSOC);
        
    } else {
        throw new Exception("Error executing the languages SQL statement: " . implode(", ", $stmtLangs->errorInfo()));
    }

    return $result;
}

function deletePage($ids) {
    if (empty($ids) || !is_array($ids)) {
        return false;
    }

    // Begin a transaction to ensure data consistency
    try {
        $this->mDb->beginTransaction();

        // Prepare placeholders for the IDs
        $placeholders = implode(',', array_fill(0, count($ids), '?'));

        $sqlDeleteLangs = "DELETE FROM `pages_langs` WHERE `page_id` IN ($placeholders)";
        $stmtDeleteLangs = $this->mDb->connect()->prepare($sqlDeleteLangs);
        $stmtDeleteLangs->execute($ids);
        // Select associated images to be deleted
        $sqlSelectImages = "SELECT `img` FROM `pages` WHERE `id` IN ($placeholders)";
        $stmtSelectImages = $this->mDb->connect()->prepare($sqlSelectImages);
        $stmtSelectImages->execute($ids);
        $images = $stmtSelectImages->fetchAll(PDO::FETCH_ASSOC);

// print_r($images);die();
        if (!empty($images)) {
            foreach ($images as $image) {
                $old_img = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'pages/' . $image['img'];
                if (file_exists($old_img)) {
                    @unlink($old_img); 
                }
            }
        }

        // Delete the pages
        $sqlDeletePages = "DELETE FROM `pages` WHERE `id` IN ($placeholders)";
        $stmtDeletePages = $this->mDb->connect()->prepare($sqlDeletePages);
        $stmtDeletePages->execute($ids);

        // Commit the transaction
        $this->mDb->commit();

        return true;
    } catch (PDOException $e) {
        // Rollback in case of error
        $this->mDb->rollBack();
        error_log("PDOException in deletePage: " . $e->getMessage());
        return false;
    }
}


} ?>