<?php
date_default_timezone_set('Africa/Cairo');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, x-api-key, User-Token, User-Id, Front-Lang  ,Set-From');

// Initialize error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
// ini_set('log_errors', 1);            

// Define debug mode based on environment
define('DEBUG_MODE', true); // Set to false in production

// Set error handler
set_error_handler(function($errno, $errstr, $errfile, $errline) {
    if (DEBUG_MODE) {
        error_log("Error [$errno] $errstr on line $errline in file $errfile");
    }
    return true;
});

// Include configuration and utility files
$Lang = "ar";

require_once '../includes/config.inc.php';
require_once '../php-jwt-6.0.0/php-jwt-6.0.0/src/JWT.php';
require_once 'classes/upload-class.php';
require_once 'classes/iplus.php';
require_once 'classes/class.hs256.php';
require_once 'classes/class.languages.php';
require_once 'classes/class.settings.php';
require_once 'classes/class.levels.php';

require_once 'classes/class.pages.php';
require_once 'classes/class.users.php';
require_once 'classes/class.cities.php';
require_once 'classes/class.common.php';
require_once 'classes/class.developers.php';
require_once 'classes/class.ProjectsManagement.php';
require_once 'classes/class.closing_deals_management.php';
require_once 'classes/class.silders.php';
require_once 'classes/class.statistics.php';
// Initialize objects
// try {
//     $citiesObj = new Cities();
//     $projectsMangmentOBJ = new ProjectsManagement();
// } catch (Exception $e) {
//     error_log("Failed to initialize Cities object: " . $e->getMessage());
//     if (DEBUG_MODE) {
//         throw $e;
//     }
// }

// Function to get Apache request headers


if (!function_exists('apache_request_headers')) {
    function apache_request_headers()
    {
        
        $arh = array();
        $rx_http = '/\AHTTP_/';

        foreach ($_SERVER as $key => $val) {
            if (preg_match($rx_http, $key)) {
                $arh_key = preg_replace($rx_http, '', $key);
                $rx_matches = array();
                // do some nasty string manipulations to restore the original letter case
                // this should work in most cases
                $rx_matches = explode('_', $arh_key);
                if (count($rx_matches) > 0 && strlen($arh_key) > 2) {
                    foreach ($rx_matches as $ak_key => $ak_val)
                        $rx_matches[$ak_key] = ucfirst($ak_val);
                    $arh_key = implode('-', $rx_matches);
                }
                $arh[$arh_key] = $val;
            }
        }
        return ($arh);
    }
}

$Lang = 'ar';
// Debugging: Print all received headers
$headers = apache_request_headers();
define('LANGUAGE', $headers["Front-Lang"] ? $headers["Front-Lang"] : "ar");
define('SETFROM', $headers["Set-From"] ? $headers["Set-From"] : 'web'); // هذه مهمة جدا جدا بسبب ال APP  م محمد مشرف 

define('IsTestMode', $headers["Is-Test-Mode"] == 'yes' ? true : false);
require_once 'languages/' . LANGUAGE . '.php';
// echo $headers['Front-Lang'];die();
// print_r($headers);
// die();

// echo apache_request_headers()["Authorization"];die();
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    // echo"oh";die();
    http_response_code(200);
    exit();
}


$http_response_code_status = 200;

if ($Config['mode'] == 'live' && $settings->getSettingByName('api_secrit_key_on') == '1') {
    $token = $headers['x-api-key'];
    $verfied = $hs256Obj->verifyJWT('sha256', $token);
;
    if (!$verfied || empty($token)) {
      
        $http_response_code_status = 401;
        goto out;
    }
    if ($hs256Obj->getJWT($token)) {
      
        $http_response_code_status = 401;
        goto out;
    }
    if ($verfied) {
        $hs256Obj->addjwt($token);
    }
}


if ($_REQUEST['action'] !== 'login' && 
    $_REQUEST['action'] !== 'resetPassword' && 
    $_REQUEST['action'] !== 'sendActivationCodeForRecoverPassword' &&
    $_REQUEST['action'] !== 'getAllSettings'){
    if ($_REQUEST['time']) {
        unset($_REQUEST['time']);
    }
    $user_id = $headers['User-Id'];
   
   // print_r($user_id);die();
    $_REQUEST['set_from'] = $headers['Set-From'];
    //print_r($headers);die();
    // Debugging: Check if User-Id and Authorization headers are set
    if (empty($headers['User-Token'])) {
        echo "Authorization header not found!";
        die();
    }

    $receivedToken = $headers["User-Token"];
   // print_r($receivedToken);die();
    if (empty($receivedToken)) {
     
        $http_response_code_status = 401;
        goto out;
    }

  
 //   echo $user_id;die();
    $userinfo = $userAdmObj->getUsercheckInfo($user_id);
    // print_r($userinfo);die();
    $USER_DATA = $userinfo;
 
   /// print_r($userinfo);die();
 
    //print_r($USER_DATA);die();
    $userToken = $userinfo['authentication_code'];
    //print_r($userToken);die();
  
    $verfiedUserToken = hash_equals($receivedToken, $userToken);
   // echo $verfiedUserToken;die();
    // echo $verfiedUserToken;die();

    if (!$verfiedUserToken) {
     
        $http_response_code_status = 401;
        goto out;
    }
   
    // if ($userinfo['user_level'] === null) {
    //     $http_response_code_status = 401;
    //     goto out;
    // } 

    $_REQUEST['user_id'] = $user_id;
}

if ($Config['mode'] == 'live' && $commonObj->getSettingByName('api_secrit_key_on') == '1') {
  $apiSeritKey_correct = password_verify('rAm', $apache_request_headers['AUTHORIZATION']);

  if (!$apiSeritKey_correct) {
    $http_response_code_status = 401;
    goto out;
  }

  //cheak if there api Secrit key is not Duplicate
  $is_exist = $userObj->checkSecritKeyIsExist($apache_request_headers['AUTHORIZATION']);
  // echo $is_exist;
  if ($is_exist) {
    $http_response_code_status = 401;
    goto out;
  }
  //insert api Secrit key in table
  $userObj->insertSecritKey($apache_request_headers['AUTHORIZATION']);
}



// Get Apache request headers
$apache_request_headers = apache_request_headers();

// print_r ($apache_request_headers);
// die();


$token = apache_request_headers()["AUTHORIZATION"];

$verify = $hs256Obj->verifyJWT('sha256', $token);

out:

// echo "TESTSTSF";die();
if ($http_response_code_status != 200) {
   // echo $http_response_code_status;die();
   //echo "heo";die();
    http_response_code($http_response_code_status);
    echo str_replace("\'", "'", json_encode($ret));
    $userObj->inserInApiTable($http_response_code_status, json_encode($_SERVER), json_encode($apache_request_headers), json_encode($Req, JSON_UNESCAPED_UNICODE), json_encode($_GET, JSON_UNESCAPED_UNICODE), json_encode($ret, JSON_UNESCAPED_UNICODE));
    exit();
}
// echo $verify;die();

?>