<?php

$projectsMangmentOBJ = new ProjectsMangment();

class ProjectsMangment
{

	var $mDb;
	var $mConfig;
	var $mlang;

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
	}


	function convert_object_to_array($data)
	{
        
		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}
public function getAllProjects($aStart, $aLimit, $sort, $type, $company_id, $city_id) {
    $lang_code = LANGUAGE;

    // Whitelist validation for sorting
    $allowedSortColumns = ['p.id', 'p.delivery_date', 'p.deposit', 'pl.name', 'cl.name'];
    $allowedSortTypes = ['ASC', 'DESC'];

    if (!in_array($sort, $allowedSortColumns)) {
        $sort = 'p.id'; // Default sort column
    }

    if (!in_array($type, $allowedSortTypes)) {
        $type = 'ASC'; // Default sort type
    }

        $sql = "SELECT 
        p.id AS project_id,
        p.image AS project_image,
        p.installments_years,
        p.delivery_date,
        p.deposit,
        p.sales_phone,
        p.sales_name,
        p.sales_whatsapp,
        d.img as company_image , 
        dl.name AS company_name ,
        cl.name AS city_name,
        pmtl.name AS finishing_type,
        tl.name AS project_type,
        MIN(ud.cost) AS min_price -- Min price for each project
    FROM projects_management p
    LEFT JOIN projects_management_langs pl ON p.id = pl.project_id AND pl.lang_code = :lang_code
    LEFT JOIN developers_management d ON p.company_id = d.id

    LEFT JOIN developers_management_langs dl ON d.id = dl.company_id AND dl.lang_code = :lang_code
    LEFT JOIN projects_management_type_langs pmtl ON p.finishing = pmtl.project_type_id AND pmtl.lang_code = :lang_code
    LEFT JOIN project_units ud ON p.id = ud.project_id
    LEFT JOIN unit_types_langs tl ON p.type_id = tl.unit_type_id
    LEFT JOIN cities_management_langs cl ON p.city_id = cl.city_id
    WHERE p.is_deleted = '0'
    GROUP BY p.id;
";
// print_r($sql);die();
if ($city_id){
    $sql.= " AND p.city_id  = :city_id ";
}
if ($company_id){
    
    $sql.=" AND p.company_id = :company_id";
}
    // Search filter
   

    // Ordering
    $sql .= " ORDER BY $sort $type";

    // Pagination
    if ($aLimit) {
        $sql .= " LIMIT " . (int)$aStart . ", " . (int)$aLimit;
    }

    try {
        $stmt = $this->mDb->connect()->prepare($sql);

        // Bind parameters
        $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
        
        if ($city_id){
            $stmt->bindParam(":city_id",$city_id);
        }
        if ($company_id){
            $stmt->bindParam(":company_id",$company_id);
        }

        // Execute query
        $stmt->execute();

        // Fetch results
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
        return $results;
    } catch (PDOException $e) {
        
        error_log("PDOException in getAllProjects: " . $e->getMessage());
        return [];
    }
}


public function getAllProjectCount($company_id,$city_id) {
    $sql = "SELECT COUNT(p.id)
            FROM projects_management p 
            WHERE p.is_deleted = '0'";
    if ($city_id){
        $sql.= " AND p.city_id  = :city_id ";
    }
    if ($company_id){
        
        $sql.=" AND p.company_id = :company_id";
    }
 

    try {
        
        $stmt = $this->mDb->connect()->prepare($sql);
        if ($city_id){
            $stmt->bindParam(":city_id",$city_id);
        }
        if ($company_id){
            $stmt->bindParam(":company_id",$company_id);
        }
        $stmt->execute(); // تصحيح اسم الدالة
        $data = $stmt->fetch(PDO::FETCH_COLUMN); // استخدام FETCH_ASSOC لسهولة الوصول
        
        return $data; // إرجاع العدد
    } catch (PDOException $e) {
        // تسجيل الخطأ في حال حدوث استثناء
        error_log("Error in getAllProjectCount: " . $e->getMessage());
        return 0; // إرجاع 0 عند حدوث خطأ
    }
}

public function getOneProject($id) {
    $lang_code = LANGUAGE; // Assuming LANGUAGE is a constant or defined variable

    $sql = "SELECT 
        p.id AS project_id,
        p.image AS project_image,
        p.installments_years,
        p.delivery_date,
        p.deposit,
        p.sales_phone,
        p.sales_name,
        p.sales_whatsapp,
        pl.name AS project_name,
        d.img AS company_image,
        dl.name AS company_name,
        cl.name AS city_name,
        pmtl.name AS finishing_type,
        tl.name AS project_type
    FROM projects_management p
    LEFT JOIN projects_management_langs pl ON p.id = pl.project_id AND pl.lang_code = :lang_code
    LEFT JOIN developers_management d ON p.company_id = d.id
    LEFT JOIN developers_management_langs dl ON d.id = dl.company_id AND dl.lang_code = :lang_code
    LEFT JOIN projects_management_type_langs pmtl ON p.finishing = pmtl.project_type_id AND pmtl.lang_code = :lang_code
    LEFT JOIN cities_management_langs cl ON p.city_id = cl.city_id
    LEFT JOIN unit_types_langs tl ON p.type_id = tl.unit_type_id AND tl.lang_code = :lang_code
    WHERE p.is_deleted = '0' AND p.id = :id";

    try {
        $stmt = $this->mDb->connect()->prepare($sql);

        // Bind parameters
        $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        // Execute query
        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        return $result ?: [];
    } catch (PDOException $e) {
        error_log("PDOException in getOneProject: " . $e->getMessage());
        return [];
    }
}

public function getUnitsDetails($projectId) {
    $lang_code = LANGUAGE;

    $sql = "SELECT 
        ud.unit_id,
        ud.cost,
        ud.space,
        ut.type AS unit_type,
        tl1.name AS unit_type_name
    FROM project_units ud
    LEFT JOIN unit_types ut ON ut.id = ud.unit_id
    LEFT JOIN unit_types_langs tl1 ON ud.unit_id = tl1.unit_type_id AND tl1.lang_code = :lang_code
    WHERE ud.project_id = :project_id";

    try {
        $stmt = $this->mDb->connect()->prepare($sql);

        // Bind parameters
        $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
        $stmt->bindParam(':project_id', $projectId, PDO::PARAM_INT);

        // Execute query
        $stmt->execute();

        // Fetch the results
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

        return $results ?: [];
    } catch (PDOException $e) {
        error_log("PDOException in getUnitsDetails: " . $e->getMessage());
        return [];
    }
}

public function getProjectImages($projectId) {
    $sql = "SELECT 
        pmi.file AS project_file
    FROM projects_management_images pmi
    WHERE pmi.project_id = :project_id";

    try {
        $stmt = $this->mDb->connect()->prepare($sql);

        // Bind parameter
        $stmt->bindParam(':project_id', $projectId, PDO::PARAM_INT);

        // Execute query
        $stmt->execute();

        // Fetch the results
        $results = $stmt->fetchAll(PDO::FETCH_COLUMN); // Fetch only the file column

        return $results ?: [];
    } catch (PDOException $e) {
        error_log("PDOException in getProjectImages: " . $e->getMessage());
        return [];
    }
}


public function getProjectDetails($id) {
    $project = $this->getOneProject($id);

    if (empty($project)) {
        return []; // Project not found
    }

    // Get additional details
    $project['units'] = $this->getUnitsDetails($id);
    $project['project_files'] = $this->getProjectImages($id);

    return $project;
}

public function getYourProfit($temp)
{
    try {
        // جلب عمولة المشروع من قاعدة البيانات
        $sql = "SELECT commision FROM projects_management WHERE id = :project_id";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(":project_id", $temp['project_id']);
        $stmt->execute();
        $projectCommission = $stmt->fetch(PDO::FETCH_COLUMN);

        // جلب الإعدادات من المصفوفة
        $taxRate = $this->mConfig['Tax']; // نسبة الضريبة
        $dashboardCommissionRate = $this->mConfig['commission']; // نسبة عمولة لوحة التحكم

     
$data['commission'] = number_format((float)$projectCommission, 2, '.', ''); // تحويل الرقم العشري إلى نص بدقة 2
$data['total_commission'] = number_format((float)($projectCommission * $temp['cost']), 2, '.', ''); // العمولة الكلية
$data['tax'] = number_format((float)($taxRate * $data['total_commission']), 2, '.', ''); // قيمة الضريبة
$data['net_commission'] = number_format((float)($data['total_commission'] - $data['tax']), 2, '.', ''); // صافي العمولة
$data['profit'] = number_format(($data['net_commission'] - ($data['net_commission'] * $dashboardCommissionRate)), 2); // الربح الصافي


if (empty($data))
{ return ['data'=>[],
        'success'=>false ];
}
// Debugging: طباعة البيانات للتأكد
return [
    'data'=>$data,
    'success' =>true];
  
    } catch (Exception $e) {
        // معالجة الخطأ
        return [];
    }
}












} ?>