<?php

$userAdmObj = new users();


class users
{

    var $mDb;
    var $mConfig;
    // var $notificate;

    function __construct()
    {
        global $Config;
        $this->mDb = new iplus();
        $this->mConfig = $Config;
        //    $this->notificate = new pushmessage();
    }

    function convert_object_to_array($data)
    {

        // print_r($data);die();
        if (is_object($data)) {
            $data = get_object_vars($data);
        }

        if (is_array($data)) {
            return array_map(__METHOD__, $data);
        } else {
            return $data;
        }
    }

    /*  function getUserLevel($request)
      {

          $user_id = $request['user_id'];
          $roles = $request['roles'];

          $select = implode(", ", $roles);

          $query = "SELECT u.`id` AS 'user_id_in_users', {$select} FROM `users` u";
          $query .= " LEFT JOIN `user_levels` ul ON ul.id = u.user_level ";
          $query .= " WHERE u.`id` = '{$user_id}' ";
          // echo $query; die();
          return $this->mDb->getRow($query);
      }*/
      public function getUsersLevels($leveltype = null, $provider_id = null)
      {
       
          // Base SQL query
          $sql = "SELECT l.`id`, lv.`name`
                  FROM `user_levels` l
                  LEFT JOIN `user_levels_langs` lv ON l.id = lv.user_level_id AND lv.lang_code = :lang_code";
          
          // Optionally include the condition based on level type
          if ($leveltype == 'provider' && !empty($provider_id)) {
              $sql .= " WHERE l.`provider_id` = :provider_id";
          }
      
          // Prepare and execute the query
          $stmt = $this->mDb->connect()->prepare($sql);
          $lang_code = LANGUAGE;
          $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
      
          // Bind the provider_id if necessary
          if ($leveltype == 'provider' && !empty($provider_id)) {
              $stmt->bindParam(':provider_id', $provider_id, PDO::PARAM_INT);
          }
      try{
          $stmt->execute();}
          catch(PDOException $e){
            echo $e->getMessage();
          }
          $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
      
          // Return the results
          return [
              "status" => 200,
              "success" => true,
              "data" => $data,
          ];
      }
      
function login($email, $password)
{

    if (empty($email) || empty($password)) {
        return [
            "status" => "failed",
            "message" => "Please enter email and password."
        ];
    }

    $email = $this->sanitizeInput($email);
    $result = array();


    $sql = "SELECT `id`, `password`, `user_level` FROM `users` WHERE `email` = :email";

    try {
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':email', $email, PDO::PARAM_STR);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
      
        if ($result) {
            // if ($result['type'] !== 'admin') {
            //     return [
            //         'status' => 401,
            //         'success' => false,
            //         'data' => "Not allowed to login"
            //     ];
            // }
          //  print_R($password);die();
            if (password_verify($password, $result['password'])) {
            
                $check_query = "SELECT u.id, u.email, u.authentication_code, u.full_name, u.img, u.user_level

         FROM `users` u
         LEFT JOIN `user_levels` lvl ON u.user_level = lvl.id 
         LEFT JOIN `user_levels_langs`lv ON lv.user_level_id = lvl.id AND lv.lang_code = :lang
         WHERE u.`email` = :email 
           AND u.is_deleted = '0'";
                // print_r($check_query);die();
                $stmt = $this->mDb->connect()->prepare($check_query);
                $stmt->bindParam(':email', $email, PDO::PARAM_STR);
                $langg = LANGUAGE;
                $stmt->bindParam(':lang',$langg);
                $stmt->execute();

                $userData = $stmt->fetch(PDO::FETCH_ASSOC);
                //Put the Devices
            if ($userData == false ){
                return [
                    "status" => 200,
                    "success" => false,
                    "data" => 'Not Registred'
                ];
            }




                return [
                    "status" => 200,
                    "success" => true,
                    "data" => $userData
                ];

            } else {
                return [
                    "status" => 401,
                    "success" => false,
                    "message" => "Incorrect password."
                ];
            }
        } else {
            return [
                "status" => 401,
                "success" => false,
                "message" => "Invalid email."
            ];
        }
    } catch (PDOException $e) {
        // Log the error
        return [
            'status' => 500,
            'success' => false,
            'message' => "An error occurred." // Optionally include the error message: $e->getMessage()
        ];
    }
}

   
 function getAllUsers($full_name, $startDate, $endDate, $start, $aIteamPerPage, $sort, $type,$leveltype)
{
    try {

        $sql = "SELECT u.id, u.full_name, u.phone, u.email, u.status, u.img, u.date_added,
                 u2.full_name AS AddedBy_name";
         if ($leveltype == 'admin') {
            $sql .= " , lvl.name AS level_name ";
        }        
        $sql.= " 
                FROM `users` u
              
                LEFT JOIN `users` u2 ON u.added_by = u2.id";

        // Apply INNER JOIN only for admin level users
        if ($leveltype == 'admin') {
            $sql .= " INNER JOIN user_levels ON u.user_level = user_levels.id
                    LEFT JOIN user_levels_langs lvl  ON lvl.user_level_id = u.user_level AND lvl.lang_code = :lang_code ";
        }
        $whereClause = [];
        $whereClause[] = "u.`is_deleted` = '0'";
        
        if ($full_name) {
            $whereClause[] = "u.`full_name` LIKE :full_name";
        }

        if ($startDate && $endDate) {
            $whereClause[] = "`date_added` BETWEEN :start_date AND :end_date";
        }
        if ($leveltype != 'admin') {
            $whereClause[] = " u.`user_level` IS NULL ";
        }
        if (!empty($whereClause)) {
            $sql .= " WHERE " . implode(" AND ", $whereClause);
        }

        $sql .= " ORDER BY {$sort} {$type}";
        $sql .= " LIMIT {$start}, {$aIteamPerPage}";
       
        // print_r($sql);  die();
        $stmt = $this->mDb->connect()->prepare($sql);

        if ($full_name) {
            $full_name = "%{$full_name}%";
            $stmt->bindParam(":full_name", $full_name, PDO::PARAM_STR);
        }

        if ($startDate && $endDate) {
            $stmt->bindParam(":start_date", $startDate, PDO::PARAM_STR);
            $stmt->bindParam(":end_date", $endDate, PDO::PARAM_STR);
        }
        if ($leveltype == 'admin') {
            $lang_code = LANGUAGE;
            $stmt->bindParam(':lang_code',$lang_code);
         }

        $stmt->execute();
        $allusers = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $sqlForCount = "SELECT COUNT(u.id) FROM `users` u";
        if ($leveltype == 'admin') {
            $sqlForCount .= " INNER JOIN user_levels ON u.user_level = user_levels.id";
        }

        $sqlForCount .= " WHERE u.`is_deleted` = '0'";
        if ($full_name) {
            $sqlForCount .= " AND full_name LIKE :full_name";
        }
        if ($leveltype != 'admin'){
            $sqlForCount .=  "AND u.user_level IS NULL";
           }

        $stmtForCount = $this->mDb->connect()->prepare($sqlForCount);
        if ($full_name) {
          $stmtForCount->bindParam(':full_name',$full_name)  ;
        }

        $stmtForCount->execute();
        $count = $stmtForCount->fetch(PDO::FETCH_COLUMN);

        return [
            "status" => 200,
            "success" => true,
            "data" => $allusers,
            "count" => $count
        ];

    } catch (PDOException $e) {
        return [
            "status" => 500,
            "success" => false,
            "message" => "An error occurred: " . $e->getMessage()
        ];
    }
}

    /////////////////////////////////////// Admins ///////////////////////////////////////////////

  function addEditUser($request, $user_id)
{
    
    global $USER_DATA;
    unset($request['action']);

    $dateTime = date('Y-m-d H:i:s');
   
   
    if ($user_id == "") {
        $request['password'] = password_hash($request['password'], PASSWORD_DEFAULT);

        $sql = "INSERT INTO `users` SET 
                `full_name` = :full_name,
              
                `phone` = :phone, 
                `email` = :email,
                `password` = :password, 
                `set_from` = :set_from,
                `added_by` = :added_by, 
                `date_added` = :date_added";

        if ($request['status'] !== null) {
            $sql .= " , `status` = :status";
        }
        if ($request['img']) {
            $sql .= " , `img` = :img";
        }
      
        if ($request['user_level']){
            $sql.= " , `user_level` = :user_level";
        }

        try {
            $this->mDb->beginTransaction();
           
            $stmt = $this->mDb->connect()->prepare($sql);
            $params = [
                ':full_name' => $request['full_name'],
                
                ':phone' => $request['phone'],
                ':email' => $request['email'],
                ':password' => $request['password'],
                ':set_from' => $request['set_from'],
                ':added_by' => $request['user_id'],
                ':date_added' => $dateTime
            ];
            foreach ($params as $key => $value) {
                $stmt->bindValue($key, $value);
            }
            if ($request['status'] !== null) {
                $stmt->bindParam(':status', $request['status']);
            }
            if ($request['img']) {
                $stmt->bindParam(':img', $request['img']);
            }
           
            if ($request['user_level']){
                $stmt->bindParam(':user_level', $request['user_level']);
                
            }
            
            $stmt->execute();
            $addedUser = $this->mDb->getLastInsertId();

         

            $this->insertAuthCode($addedUser, password_hash($addedUser . $this->mConfig['apihash'], PASSWORD_DEFAULT));

        
            $this->mDb->commit();
            return [
                'id' => $addedUser,
                'status' => 200,
                'success' => true,
                'data' => $request,
           
            ];

        } catch (PDOException $e) {
            $this->mDb->rollBack();
            $this->deleteUploadedFile($request['img']);

            if ($e->errorInfo[1] === 1062) {
                return [
                    "status" => 409,
                    "success" => false,
                    "data" => "Email or Phone already exists"
                ];
            }

            return [
                "status" => 500,
                "success" => false,
                "data" => "An Error Occurred: " . $e->getMessage()
            ];
        }
    } else {
 
        try {
            if ($request['img'] != null) {
                $sqlForOldImg = "SELECT `img` FROM `users` WHERE `id` = :id";
                $stmtForOldImg = $this->mDb->connect()->prepare($sqlForOldImg);
                $stmtForOldImg->bindParam(':id', $user_id);
                $stmtForOldImg->execute();
                $oldImg = $stmtForOldImg->fetch(PDO::FETCH_COLUMN);
            }

            $sql = "UPDATE `users` SET";
            $updateFields = [];
            $params = [];

            if (!empty($request['full_name'])) {
                
                $updateFields[] = " `full_name` = :full_name";
                $params[':full_name'] = $request['full_name'];
            }
            if (!empty($request['phone'])) {
                $updateFields[] = "`phone` = :phone";
                $params[':phone'] = $request['phone'];
            }
          
            if (!empty($request['user_level'])) {
                $updateFields[] = "`user_level` = :user_level";
                $params[':user_level'] = $request['user_level'];
            }
          
            if (!empty($request['password'])) {
                $updateFields[] = "`password` = :password";
                $request['password'] = password_hash($request['password']   , PASSWORD_DEFAULT);
                $params[':password'] = $request['password'];
            }
           
            if (!empty($request['email'])) {
                $updateFields[] = "`email` = :email";
                $params[':email'] = $request['email'];
            }
            if (!empty($request['img'])) {
                $updateFields[] = "`img` = :img";
                $params[':img'] = $request['img'];
            }
            if ($request['status'] != '') {
              
                $updateFields[] = "`status` = :status";
                $params[':status'] = $request['status'];
            }
            if (!empty($request['set_from'])) {
                $updateFields[] = "`set_from` = :set_from";
                $params[':set_from'] = $request['set_from'];
            }

            $sql .= implode(", ", $updateFields);
            $sql .= " WHERE `id` = :id AND is_deleted = '0'";
            $params[':id'] = $user_id;

            $stmt = $this->mDb->connect()->prepare($sql);
            foreach ($params as $key => $value) {
                $stmt->bindValue($key, $value);
            }
            $updateCheck = $stmt->execute();         
            if ($oldImg && $updateCheck) {
                $this->deleteUploadedFile($oldImg);
            }

            return [
                "status" => 200,
                "success" => true,
                "data" => "Updated Successfully"
            ];
        } catch (PDOException $e) {
            $this->deleteUploadedFile($request['img']);
            if ($e->errorInfo[1] === 1062) {
                return [
                    "status" => 409,
                    "success" => false,
                    "data" => "Couldn't use the email or phone; already exists."
                ];
            }
            return [
                "status" => 500,
                "success" => false,
                "data" => "An Error Occurred: " . $e->getMessage()
            ];
        }
    }
}

public function deleteUser($ids)
{
    if (empty($ids)) {
        return [
            'status' => 400,
            'success' => false,
            'data' => "No user IDs provided"
        ];
    }

    try {
        // Begin transaction
        $this->mDb->beginTransaction();

        // Ensure ids are integers to avoid SQL injection
        $idString = implode(',', array_map('intval', $ids));

        // Fetch images associated with the users
        $sql = "SELECT `img` FROM `users` WHERE `id` IN ($idString)";
        $stmtForDelete = $this->mDb->connect()->prepare($sql);
        $stmtForDelete->execute();
        $allImages = $stmtForDelete->fetchAll(PDO::FETCH_COLUMN);

        if (empty($allImages)) {
            // If no users found, rollback and return
            $this->mDb->rollBack();
            return [
                'status' => 404,
                'success' => false,
                'data' => "No users found for deletion"
            ];
        }

        // Soft delete users (mark them as deleted)
        $usersql = "UPDATE `users` 
                    SET `is_deleted` = '1', `img` = NULL 
                    WHERE `id` IN ($idString)";
        $stmt = $this->mDb->connect()->prepare($usersql);
        $stmt->execute();

        $deletedCount = $stmt->rowCount();

        if ($deletedCount === 0) {
            // If no rows were updated, rollback
            $this->mDb->rollBack();
            return [
                'status' => 404,
                'success' => false,
                'data' => "No Deletion Occurred"
            ];
        }

        // Delete images from the server
        foreach ($allImages as $image) {
            $this->deleteUploadedFile($image);
        }

        // Commit transaction after all operations are successful
        $this->mDb->commit();

        return [
            'status' => 200,
            'success' => true,
            'data' => $deletedCount . " Items Deleted Successfully"
        ];
    } catch (PDOException $e) {
        // Rollback transaction on error
        $this->mDb->rollBack();

        return [
            'status' => 500,
            'success' => false,
            'data' => "An Error Occurred: " . $e->getMessage()
        ];
    }
}
        
    function insertAuthCode($aId, $authentication_code)
    {
        $sql = " UPDATE `users` SET `authentication_code` = '{$authentication_code}'";
        $sql .= " WHERE `id` = '{$aId}'";
        // echo $sql; die();
        return $this->mDb->query($sql);
    }
 function getSearchUsersByType($user_type)
{
    try {
        $sql = "SELECT u.`id`, u.`first_name`, u.`last_name`, u.`img` 
                FROM `users` u 
                WHERE u.`id` > 0 AND u.`user_type` = :user_type";

        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':user_type', $user_type, PDO::PARAM_STR);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

        return [
            "status" => 200,
            "success" => true,
            "data" => $result
        ];
    } catch (PDOException $e) {
        return [
            "status" => 500,
            "success" => false,
            "data" => "An error occurred: " . $e->getMessage()
        ];
    }
}

    function getUsersCountByType($userType)
    {

        // echo $userType;
        $sql = "SELECT COUNT(`id`) as count FROM `users`";
        $sql .= " WHERE `user_type` = :userType";

        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':userType', $userType);
        $stmt->execute();
        // print_r($stmt);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);


        if ($result && isset($result['count'])) {
            return $result['count'];
        }

        return 0;
    }
   function getUserlevel($id) {  
       try {
           $sql = "SELECT u.`id` AS userId, ul.*
                   FROM `users` u 
                   LEFT JOIN `user_levels` ul ON u.`user_level` = ul.`id`
                   WHERE u.`id` = :id";
           $stmt = $this->mDb->connect()->prepare($sql);
           $stmt->bindParam(':id', $id, PDO::PARAM_INT);
           $stmt->execute();
           $result = $stmt->fetch(PDO::FETCH_ASSOC);
           
           if ($result) {
               return 
                  $result;
               
           } else {
               return [
                   'status' => 404,
                   'success' => false,
                   'message' => 'User level not found'
               ];
           }
       } catch (PDOException $e) {
           return [
               'status' => 500,
               'success' => false,
               'message' => 'Database error'
           ];
       }
   }

function getUserInfo($id)
{ 
    // echo "Heo";die();
    try {
        $sql = "SELECT u.full_name, u.user_level, u.phone,
        u.email, u.img, u.status, u.added_by, u.date_added
 FROM `users` u
 WHERE u.`id` = :id AND u.is_deleted = '0' 
";
//   print_r($sql);die();
        
        $lang_code = LANGUAGE;
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':id', $id);
      
        
       
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);
      
        

        return [
            'status' => 200,
            'success' => true,
            'data' => $result
        ];
    } catch (PDOException $e) {
        return [
            'status' => 500,
            'success' => false,
            'data' => 'An error occurred: ' . $e->getMessage()
        ];
    }
}


    private function checkFields($request, $temp)
    {
        if (
            empty($request['first_name'])
            || empty($request['last_name'])
            || empty($request['email'])
            || empty($request['mobile'])
            || empty($request['password'])
        ) {
            $this->deleteUploadedFile($temp);
            return [
                "status" => 400,
                "message" => "All Fields Are Required"
            ];

        }
        if (!filter_var($request['email'], FILTER_VALIDATE_EMAIL)) {
            $this->deleteUploadedFile($temp);
            return [
                "status" => 400,
                "message" => "Invalid Email"
            ];
        }
        if (!preg_match("/^[0-9]{10,15}$/", $request['mobile'])) {
            $this->deleteUploadedFile($temp);
            return [
                "status" => 400,
                "message" => "Invalid Mobile Number"
            ];
        }
        return true;


    }


    function sanitizeInput($input)
    {
        if (is_array($input)) {
            return array_map([$this, 'sanitizeInput'], $input);
        } else {
            return htmlspecialchars(strip_tags(trim($input)));
        }
    }
    private function deleteUploadedFile($temp)
    {
        $uploadedFilePath = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'users/' . $temp;
        if (file_exists($uploadedFilePath))
            unlink($uploadedFilePath);


    }


    function getUsercheckInfo($id)
    {
        // echo $id;die();
        $sql = "SELECT u.*,  
        CASE 
            WHEN u.user_level IS NOT NULL THEN 'admin'
            ELSE NULL
        END AS level_code 
        FROM `users` u 
        LEFT JOIN user_levels l ON u.user_level = l.id 
        WHERE u.`id` = :id 
        AND u.is_deleted = '0'";
        $stmt = $this->mDb->connect()->prepare($sql);
        // print_r($stmt);die();
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
       // print_r($result);die();
        return $result;
    }

   
    
    


    
   
  
    
  
  


function getuserDetails ($id){

    $sql =  "SELECT  u.* ,us.stage_id,us.school_id , usc.school_id 
    , ul.code ,ug.strategic_goals_id ,fo.field_id
    FROM users u
    LEFT JOIN `manger_stages` us  ON u.id = us.user_id 
    LEFT JOIN `user_school` usc ON u.id = usc.user_id
    LEFT JOIN `strategic_goals_users` ug ON u.id= ug.user_id 
    LEFT JOIN `fields_owners` fo ON u.id = fo.user_id 
    LEFT JOIN `user_levels` ul ON u.user_level = ul.id 
    WHERE u.id =:id";
      $stmt = $this->mDb->connect()->prepare($sql);
   
      $stmt->bindParam(":id", $id);
      try{
      $stmt->execute();
      }
      catch (PDOException $e) {
        echo $e->getMessage();
    }
      $data = $stmt->fetch(PDO::FETCH_ASSOC);
    return $data;


}


public function deleteAccount()
{
    global $USER_DATA; 

    try {
        // Mark the user as deleted
        $sql = "UPDATE users SET is_deleted = '1' WHERE id = :id";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':id', $USER_DATA['id'], PDO::PARAM_INT);
        $stmt->execute();

        // Check if a row was affected
        if ($stmt->rowCount() == 1) {
            return [
                'status' => 200,
                'success' => true,
                'data' => 'Account successfully deleted.'
            ];
        } else {
            return [
                'status' => 200,
                'success' => false,
                'data' => 'No account found to delete.'
            ];
        }
    } catch (PDOException $e) {
        // Handle potential errors gracefully
        return [
            'status' => 500,
            'success' => false,
            'data' => 'An error occurred: ' . $e->getMessage()
        ];
    }
}
public function logout($request)
{
    global $USER_DATA;

    // Step 1: Fetch the token ID from the `device_token` table
    $sql = "SELECT id FROM device_token WHERE device_token_id = :device_token_id";
    $stmt = $this->mDb->connect()->prepare($sql);
    $stmt->bindParam(':device_token_id', $request['token'], PDO::PARAM_STR);
    $stmt->execute();
    
    // Fetch the token ID
    $TokenId = $stmt->fetch(PDO::FETCH_COLUMN);

    // Step 2: Check if the TokenId was found
    if (!$TokenId) {
        return [
            'status' => 404,
            'data' => 'Token not found',
            'success' => false
        ];
    }

    // Step 3: Update the `devices` table to set login = 0
    $sqlForUpdate = "UPDATE devices SET login = 0 WHERE user_id = :user_id AND device_token_id = :device_token_id";
    $stmt = $this->mDb->connect()->prepare($sqlForUpdate);
    $stmt->bindParam(':user_id', $USER_DATA['id'], PDO::PARAM_INT);
    $stmt->bindParam(':device_token_id', $TokenId, PDO::PARAM_INT);
    $stmt->execute();

    // Step 4: Check if the update was successful
    if ($stmt->rowCount() == 1) {
        return [
            'status' => 200,
            'data' => 'Logged Out',
            'success' => true
        ];
    } else {
        return [
            'status' => 500,
            'data' => 'An error occurred during logout',
            'success' => false
        ];
    }
}

public function checkEmailFind($email){
    try{
        $sql = "SELECT id FROM `users` WHERE `email` = :email ";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':email', $email);
        $stmt->execute();
        $id = $stmt->fetch(PDO::FETCH_COLUMN);
        // echo $email;die();

        return $id;
    }catch(Exception $e){
        echo $e->getMessage();die();
    }
    
}

public function insertVerificationCode($email, $code){
    try{
        $timeAfter10Minutes = date('Y-m-d H:i:s', strtotime('+10 minutes'));

        $sql  = "INSERT INTO `email_codes` SET ";
        $sql .= " `email` = :email ";
        $sql .= ", `code` = :code ";
        $sql .= ", `expire_time` = :expire_time ";
        $sql .= ", `used` = '0' ";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(":email",$email);
        $stmt->bindParam(":code",$code);
        $stmt->bindParam(":expire_time",$timeAfter10Minutes);
        // echo $sql;die();

        return $stmt->execute();

    }catch(Exception $e){
        echo $e->getMessage();die();
    }

    
    
}

public function getUserEmail($code){
    try{
        $sql = "SELECT email FROM `email_codes` WHERE `code` = :code AND `expire_time` > NOW() AND used != '1' ";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':code', $code);
        $stmt->execute();
        $id = $stmt->fetch(PDO::FETCH_COLUMN);
        // echo $code;die();

        return $id;
    }catch(Exception $e){
        echo $e->getMessage();die();
    }
    
}

public function resetPassword($temp){
    try{
        // print_r($temp);die();
        $sql  = "UPDATE `users` SET ";
        $sql .= " `password` = :password ";
        $sql .= " WHERE `email` = :email";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':email', $temp['email']);
        $stmt->bindParam(':password', $temp['password']);
        // echo $sql;die();
        $res_1 = $stmt->execute();

        if(!$res_1){
            return false;
        }

        $sql  = "UPDATE `email_codes` SET ";
        $sql .= " `used` = '1' ";
        $sql .= " WHERE `email` = :email";
        $sql .= " AND `code` = :code";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':email', $temp['email']);
        $stmt->bindParam(':code', $temp['code']);
        // echo $sql;die();
        return $stmt->execute();
        
    }catch(Exception $e){
        echo $e->getMessage();die();
    }
    
}
  
  
  
  public function chickEmail($email)
{
    try{
        $sql = "SELECT 1 FROM `users` WHERE `email` = :email";
        $stmt = $this -> mDb -> connect() -> prepare($sql);
        $stmt->bindParam(":email", $email);
        $stmt->execute();
        $res = $stmt->fetch(PDO::FETCH_COLUMN);
        return $res ? $res :"";
    }catch(Exception $e){
        echo $e->getMessage();die();
    }
}
  
  
  public function chickMobile($mobile)
{
    try{
        $sql = "SELECT 1 FROM `users` WHERE `phone` = :phone";
        $stmt = $this -> mDb -> connect() -> prepare($sql);
        $stmt->bindParam(":phone", $mobile);
        $stmt->execute();
        $res = $stmt->fetch(PDO::FETCH_COLUMN);
        return $res ? $res :"";
    }catch(Exception $e){
        echo $e->getMessage();die();
    }
}

}